// =============================================================================
// -----------------------------------------------------------------------------
// Monitor (OpenGL)
// -----------------------------------------------------------------------------

#include <stdio.h>
#include <windows.h>
#include "bitmap.h"

int main ( )

{
	IMG Image;
	Image.SizeX = 40;
	Image.SizeY = 32;
	Image.Size = Image.SizeX * Image.SizeY;
	Image.Data = (PIX_BGRA*) malloc (Image.Size * sizeof (PIX_BGRA));
	for (int Loc = 0, X = 0; X < Image.SizeX; X += 8)
	{
		for (int Y = 0; Y < Image.SizeY; Y += 8)
		{
			for (int YP = 0; YP < 8; YP++)
			{
				for (int XP = 0; XP < 8; XP++, Loc++)
				{
					int Pos = (X + XP) + ((Y + YP) * Image.SizeX);
					Image.Data [Pos].Red   = (Loc >> 0x10) & 0xFF;
					Image.Data [Pos].Green = (Loc >> 8) & 0xFF;
					Image.Data [Pos].Blue  = Loc & 0xFF;
				}
			}
		}
	}
	FlipImage (&Image);
	SaveBMP (&Image, "Film Texture.bmp", 24);
	free (Image.Data); Image.Data = NULL;
	return (0x00);
}

// =============================================================================
